/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareEvent15Rule;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class HardwareEvent15RuleBase {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private ArrayList rules = new ArrayList();

    public void addRule(HardwareEvent15Rule rule) {
        this.rules.add(rule);
    }

    public HardwareEvent15Rule findRule(String refCode) {
        Trace.trace(TRACE_MASKD, "Find rule based of Key message " + refCode);
        HardwareEvent15Rule returnRule = null;
        int i = 0;
        while (i < this.rules.size()) {
            HardwareEvent15Rule thisRule = (HardwareEvent15Rule)this.rules.get(i);
            if (thisRule != null) {
                Trace.trace(TRACE_MASKD, "have a rule to work with" + thisRule.getTypeID().trim());
            } else {
                Trace.trace(TRACE_MASKD, "do not have a rule to work with");
            }
            ArrayList refcodes = thisRule.getRefCode();
            int y = 0;
            while (y < refcodes.size()) {
                try {
                    if (Pattern.matches((String)refcodes.get(y), refCode)) {
                        return thisRule;
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKD, "Error using regular expressions " + e);
                }
                if (((String)refcodes.get(y)).equals("null")) {
                    returnRule = thisRule;
                }
                ++y;
            }
            ++i;
        }
        return returnRule;
    }
}

